# File : "mfCommands.tcl"
#                        Created : 2001-02-06 22:07:36
#              Last modification : 2001-02-14 20:00:14
# Author : Bernard Desgraupes
# e-mail : <berdesg@easynet.fr>
# www : <http://perso.easynet.fr/~berdesg/>
# Description : this file is part of the Metafont Mode package for 
# Alpha. See comments at the beginning of 'mfMode.tcl'.
# 

namespace eval Mf {}


# -------------------------------------------------------------------------
# Menus and submenus items procs
# -------------------------------------------------------------------------

proc Mf::menuProc {menu item} {
    global mf_params MfmodeVars 
    switch $item {
	"switchToMetafont" {app::launchFore $MfmodeVars(mfAppSig)}
	"runTheBuffer" {
	    Mf::setnames [win::Current]
	    if ![Mf::checkdirty] return
	    Mf::runbufferProc
	}
	"saveAndRun" {
	    save
	    Mf::setnames [win::Current]
	    Mf::runbufferProc
	}
	"runAFile" {
	    catch {getfile "Select a \".mf\" file to process"}  name
	    if {$name==""} return
	    edit $name
	    Mf::setnames [win::Current]
	    Mf::runbufferProc
	}
	"runAFolder" {Mf::runafolderProc}
	"runCurrentFolder" {Mf::runcurrfoldProc}
	"newFontTemplate" {Mf::newtemplateProc}
	"makeLongMenu" {Mf::makeLongMenu 1}
	"makeShortMenu" {Mf::makeLongMenu 0}
    }
}

proc Mf::convertFilesProc {submenu item} {
    global mf_params     
    switch -regexp $item {
	"convertGfToPk"  {
	    Mf::setnames [win::Current]
	    Mf::findgfFile
	    Mf::dopkProc
	}
	"convertGfToDvi"  {
	    Mf::setnames [win::Current]
	    Mf::findgfFile
	    Mf::dodviProc
	    set mf_params(prefixdvi) ""
	    menu::buildSome convertFiles
	}
	"convert.*\.dvi" {
	    Mf::setnames [win::Current]
	    Mf::dviToPsProc
	}
	"view.*\.dvi"  {
	    Mf::setnames [win::Current]
	    Mf::viewdviProc
	}
	"convert.*\.tfm"  {
	    Mf::setnames [win::Current]
	    set mf_params(converter) tftopl
	    Mf::postProcOne
	    set mf_params(prefixpl) ""
	    menu::buildSome convertFiles
	}
	"tfmToPl..." -
	"vfToVpl..." -
	"plToTfm..." -
	"vplToVf..." {
	    Mf::convertMetrics [string trimright $item .]
	}
    }
}

proc Mf::convertMetrics {type} {
    global mf_params
    if ![Mf::metricsDialog $type] return
    Mf::selectToPostProcess
}

proc Mf::metricsDialog {type} {
    global mf_params
    set convertlist $mf_params(convertopt)
    switch $type {
	"tfmToPl" {
	    set mf_params(converter) "tftopl"
	    set mf_params(extension) tfm
	}
	"vfToVpl" {
	    set mf_params(converter) "vftovp"
	    set mf_params(convertidx) 0
	    set mf_params(extension) vf
	    return 1
	}
	"plToTfm" {
	    set mf_params(converter) "pltotf"
	    set mf_params(extension) pl
	}
	"vplToVf" {
	    set mf_params(converter) "vptovf"
	    set mf_params(extension) vpl
	}
    }
    set args ""
    lappend args [list -t "Apply $mf_params(converter) to" 20 40 160 60 \
      -b Apply 230 90 310 110 \
      -b Cancel 130 90 210 110 ]
    set y 40
    eval lappend args [list [dialog::menu 135 y $mf_params(convertopt) [lindex $mf_params(convertopt) $mf_params(convertidx)]]]
    set mf_params(dlgvalues) [eval dialog -w 320 -h 120 [join $args]]
    return [Mf::getDialogValues]
}

proc Mf::getDialogValues {} {
    global mf_params
    if {[lindex $mf_params(dlgvalues) 1]} {return 0}    
    set mf_params(convertidx) [lsearch -exact $mf_params(convertopt) [lindex $mf_params(dlgvalues) 2]]
    return 1
}

proc Mf::otherfilesProc {submenu item} {
    global mf_params 
    global tileLeft tileTop tileWidth errorHeight 
    switch -regexp $item {
	"openplain.mf" {Mf::openplainmfProc}
	"openmodes.mf" {Mf::openmodesmfProc}
	"open.*\.log$" {
	    Mf::setnames [win::Current]
	    Mf::editlogProc
	}
	"open.*\.pl$" {
	    Mf::setnames [win::Current]
	    Mf::editplProc
	}
	"selectAFolder..."  {
	    catch {get_directory -p "Select a folder."} mf_params(currentdir)
	    if {$mf_params(currentdir) == ""} { return }
	    set mf_params(prefixrmall) ""
	    set mf_params(folderpath) $mf_params(currentdir)
	    menu::buildSome otherFiles
	}
	"currentFolderIs:"  {
	    alertnote "Current folder is: $mf_params(currentdir)"
	}
	"metafontBindings" {
	    set mess "KEY BINDINGS AVAILABLE IN METAFONT MODE\n\n"
	    append mess "Press 'ctrl-m', release, then hit one of the following letters :\n"
	    append mess "  'b'    to process the <b>uffer\n"
	    append mess "  'c'    to edit the macro <c>ommands file 'plain.mf'\n"
	    append mess "  'd'    to process a <d>irectory\n"
	    append mess "  'f'    to process a <f>ile\n"
	    append mess "  'g'    to edit the lo<g> file\n"
	    append mess "  'i'    to convert gf file to dv<i>\n"
	    append mess "  'k'    to convert gf file to p<k>\n"
	    append mess "  'l'    to select <l>ocalfont mode\n"
	    append mess "  'm'    to edit the <m>odes file 'modes.mf'\n"
	    append mess "  'n'    to create a <n>ew font template\n"
	    append mess "  'p'    to select <p>roof mode\n"
	    append mess "  's'    to select <s>moke mode\n"
	    append mess "  't'    to convert <t>fm file to pl\n"
	    append mess "  'u'    to select <u>ser defined mode\n"
	    append mess "  'v'    to <v>iew the d<v>i\n"
	    new -g $tileLeft $tileTop [expr int($tileWidth*.5)] \
	      [expr int($errorHeight + 60)] -n "* Metafont Bindings *" \
	      -info $mess
	    set start [minPos]
	    while {![catch {search -f 1 -s -r 1 {('|<)[a-z-]+('|>)} $start} res]} {
		eval text::color $res 1
		set start [lindex $res 1]
	    }
	    text::color [minPos] [nextLineStart [minPos]] 5
	    refresh
	    changeMode Mf
	}
    }
}

# Proc to dimm/undimm the items of the OtherFiles submenu
# depending on the existence of auxiliary files
proc Mf::rebuildSubmenus {name} {
    global mfMenu mf_params
    Mf::setnames [win::Current]
    if {![regexp ".mf" $mf_params(tailfilename)] && ![regexp ".pl" $mf_params(tailfilename)]} {
	set mf_params(prefixgf) "("
	set mf_params(prefixdvi) "("
	set mf_params(prefixlog) "("
	set mf_params(prefixtfm) "("
	set mf_params(prefixpl) "("
    } else {
	if {[file exists [file join $mf_params(outputfolder) $mf_params(basefilename).pl]]} {
	    set mf_params(prefixpl) ""
	} else {
	    set mf_params(prefixpl) "("
	}
	if {[file exists [file join $mf_params(outputfolder) $mf_params(basefilename).dvi]]} {
	    set mf_params(prefixdvi) ""
	} else {
	    set mf_params(prefixdvi) "("
	}
	if {$mf_params(done) || [file exists [file join $mf_params(outputfolder) $mf_params(basefilename).log]]} {
	    set mf_params(prefixgf) ""
	    set mf_params(prefixlog) ""
	} else {
	    set mf_params(prefixgf) "("
	    set mf_params(prefixlog) "("
	}
	if {$mf_params(tfmdone) || [file exists [file join $mf_params(outputfolder) $mf_params(basefilename).tfm]]} {
	    set mf_params(prefixtfm) ""
	} else {
	    set mf_params(prefixtfm) "("
	}
    }
    menu::buildSome convertFiles
    menu::buildSome otherFiles
    set mf_params(done) 0
    set mf_params(tfmdone) 0
}

# Choosing Metafont printer mode
proc Mf::choosemodeProc {menu item} {
    global MfmodeVars mf_params
    switch $item {
	"proof" -
	"smoke" {
	    set mf_params(chosenMode) $item
	    Mf::choosemodeMark $item
	    message "mode $item - no tfm produced"
	}
	"localfont" {
	    set mf_params(chosenMode) localfont
	    Mf::choosemodeMark localfont
	    message "mode localfont"
	}
	"userDefined" {
	    set mf_params(chosenMode) $MfmodeVars(mfModeForPrinter)
	    Mf::choosemodeMark userDefined
	    message "mode \"$MfmodeVars(mfModeForPrinter)\""
	    alertnote "Current user defined mode is \"$MfmodeVars(mfModeForPrinter)\".\
	      You can change this in the Current Mode Prefs."
	}
    }
}

proc Mf::choosemodeMark {var} {
    Mf::clearAllModes
    markMenuItem metafontMode $var 1
}

proc Mf::clearAllModes {} {
    foreach i {"proof" "smoke" "localfont" "userDefined"} {
	markMenuItem metafontMode $i 0
    } 
}

# Choosing Metafont processing Options
proc Mf::processingoptProc {menu item} {
    global mf_params
    switch $item {	
	"mag..." {
	    catch {prompt "Choose a magnification" $mf_params(mag)} res
	    if {$res == "cancel"} {return}
	    if {$res == 1} {
		set mf_params(magflag) 0
		set mf_params(mag) $res
	    } else {
		set mf_params(magstep) 0
		set mf_params(magstepflag) 0
		set mf_params(magflag) 1
		set mf_params(mag) $res
	    }
	}
	"magstep..." {
	    catch {prompt "Choose a magstep coefficient " $mf_params(magstep)} res
	    if {$res == "cancel"} {return}
	    if {$res == 0} {
		set mf_params(magstepflag) 0
		set mf_params(magstep) $res
	    } else {
		set mf_params(mag) 1
		set mf_params(magflag) 0
		set mf_params(magstepflag) 1
		set mf_params(magstep) $res
	    }
	}
	"baseFile..." {
	    catch {getfile "Select a base file"} mf_params(basefile)
	    set mf_params(basefile) [file tail $mf_params(basefile)] 
	    set mf_params(basefileflag) 1
# 	    markMenuItem processingOptions "baseFile..." $mf_params(basefileflag)
	}
	"clearAllOptions" {Mf::clearAllOptionsProc}
	default {Mf::Toggle $item}
    }
    Mf::markOptionsMenu
}

proc Mf::Toggle {var} {
    global mf_params
    eval set mf_params($var) [expr ![set mf_params($var)]]
    Mf::shadowMode $var
}

proc Mf::shadowMode {name} {
    global mf_params
    markMenuItem processingOptions $name [set mf_params($name)]
}

proc Mf::markOptionsMenu {} {
    global mf_params
    foreach opt [list magflag magstepflag basefileflag ] {
	regsub flag $opt "" name
	markMenuItem processingOptions "$name..." [set mf_params($opt)]
    }
    foreach opt [list gfcorners imagerules nodisplays notransforms screenchars screenstrokes] {
	markMenuItem processingOptions $opt [set mf_params($opt)]
    }
}

proc Mf::shadowList {name} {
    global mf_params
    set mf_params(mfSubmenuItems) ""
    menu::buildSome sourceFiles
}

proc Mf::shadowPrefs {name} {
    global mf_params MfmodeVars
    set mf_params($name) [set MfmodeVars($name)]
    Mf::shadowMode $name
}

proc Mf::clearAllOptionsProc {} {
    global mf_params
    foreach i [list gfcorners imagerules nodisplays notransforms screenchars screenstrokes] {
	eval set mf_params($i) 0
    }
    set mf_params(mag) 1
    set mf_params(magflag) 0
    set mf_params(magstep) 0
    set mf_params(magstepflag) 0
    set mf_params(basefileflag) 0
    set mf_params(basefile) ""
    Mf::markOptionsMenu
}

proc Mf::sourceFilesProc {menu item} {
    global mf_params MfmodeVars mfPathsArray
    if {$item == "Rebuild Source List"} {
	if {!$MfmodeVars(buildSourceFiles) || $MfmodeVars(pathToSourceFolder) == "" } {
	    alertnote "You must set the \
	      \"Path To Source Folder\" and check the \"Build Source Files\" checkbox in the Mf mode preferences."
	} else {
	    Mf::shadowList ""
	}
    } else {
	set upfold $menu
	eval [concat set upfold \[string trimleft $menu \"$mf_params(mfsymb)\"\]]
	set upfold [file join $upfold $item]
	edit $mfPathsArray($upfold)
    } 
}

proc Mf::removefilesProc {menu item} {
    switch $item {	
	"allLogFiles"  {Mf::deleteallfilesProc log}
	"allGfFiles"  {Mf::deleteallfilesProc gf}
	"allPkFiles"  {Mf::deleteallfilesProc pk}
	"allDviFiles" {Mf::deleteallfilesProc dvi}
	"allTfmFiles" {Mf::deleteallfilesProc tfm}
	"allVfFiles" {Mf::deleteallfilesProc vf}
	"allPlFiles" {Mf::deleteallfilesProc pl}
	"allVplFiles" {Mf::deleteallfilesProc vpl}
	"allOfThem" {
	    foreach ext {"log" "gf" "pk" "dvi" "tfm" "vf" "pl" "vpl"} {
		Mf::deleteallfilesProc $ext
	    }
	}
    }
    Mf::rebuildSubmenus ""
}


